 ; Ŀ
 ;   Tear - vertically respace and right justify text in a box.            
 ;   Copyright 2002, 2003, 2010 by Rocket Software Ltd.                    
 ;   A routine so good you'll cry.  Or maybe so odd...                     
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Ct1 - timer end.                                                      
 ; 
 (DEFUN CT1 (/ s t2)
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
 (rtos (- t2 t1) 2 1))
 ; Ŀ
 ;   Ct1 end.                                                              
 ; 

 ; Ŀ
 ;   Grout - Text/Attdef grdraw outliner.                                  
 ;   Arguments: SS, a selection set of textlike things.                    
 ;              Gbox, the grdraw colour, if nil then don't draw a box.     
 ;              Offdis, the offset distance for text.                      
 ;   Returns a list of four corner points, cw from top left.               
 ;   Rewritten 2010.10.10 to take Offdis as an argument.                   
 ; 
 (DEFUN GROUT (ss gbox offdis / num enam typ entt mxlst xmax xmin ymax ymin
                                                                ul ur lr ll)
  (setq num 0)
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (= typ "INSERT")
             (while (/= (setq typ (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                        "SEQEND")
                    (if (and (= typ "ATTRIB")
                             (/= (cdr (assoc 1 entt)) "")
                             (/= (cdr (assoc 1 entt)) " "))
                        (progn
                             (setq mxlst (cron enam offdis))
                             (if xmax
                                 (setq xmax (max xmax (car mxlst)))
                                 (setq xmax (car mxlst)))
                             (if xmin
                                 (setq xmin (min xmin (cadr mxlst)))
                                 (setq xmin (cadr mxlst)))
                             (if ymax
                                 (setq ymax (max ymax (caddr mxlst)))
                                 (setq ymax (caddr mxlst)))
                             (if ymin
                                 (setq ymin (min ymin (cadddr mxlst)))
                                 (setq ymin (cadddr mxlst)))))))
         (if (or (= typ "TEXT") (= typ "ATTDEF"))
             (progn
                  (setq mxlst (cron enam 0))
                  (if xmax
                      (setq xmax (max xmax (car mxlst)))
                      (setq xmax (car mxlst)))
                  (if xmin
                      (setq xmin (min xmin (cadr mxlst)))
                      (setq xmin (cadr mxlst)))
                  (if ymax
                      (setq ymax (max ymax (caddr mxlst)))
                      (setq ymax (caddr mxlst)))
                  (if ymin
                      (setq ymin (min ymin (cadddr mxlst)))
                      (setq ymin (cadddr mxlst))))))
 ; Ŀ
 ;   Make the corner point coordinates.                                    
 ; 
  (setq ul (list xmin ymax))
  (setq ur (list xmax ymax))
  (setq lr (list xmax ymin))
  (setq ll (list xmin ymin))
 ; Ŀ
 ;   Now draw the polyline around the outer extent points.                 
 ; 
  (if gbox
      (progn
           (grdraw ul ur gbox)
           (grdraw ur lr gbox)
           (grdraw lr ll gbox)
           (grdraw ll ul gbox)))
 (list ul ur lr ll))
 ; Ŀ
 ;   Grout end.                                                            
 ; 

 ; Ŀ
 ;   St1 - timer start.                                                    
 ; 
 (DEFUN ST1 (/ s)
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))
 (princ))
 ; Ŀ
 ;   St1 end.                                                              
 ; 

 ; Ŀ
 ;   VBLX - Left rejustify a column of text.                               
 ;   Takes two arguments - an ss and a left point x coordinate.            
 ;   Returns zilch.                                                        
 ; 
 (DEFUN VBLX (ss xa / num enam entt typ)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (setq ll (cons xa (cddr (assoc 10 entt))))
         (setq entt (subst (cons 10 ll) (assoc 10 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 72 0) (assoc 72 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vblx end.                                                             
 ; 

 ; Ŀ
 ;   Vbrxa - Left rejustify a column of text.                              
 ;   Takes two arguments - an ss and a right point x coordinate.           
 ;   Returns zilch.                                                        
 ; 
 (DEFUN VBRXA (ss xa / num enam entt pty pa sp)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pty (cddr (assoc 10 entt)))
         (setq pa (cons xa pty))
         (setq entt (subst (cons 72 2) (assoc 72 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbrxa end.                                                            
 ; 

 ; Ŀ
 ;   Vmov - move an ss from one Y coordinate to another.                   
 ;   Takes three arguments, a base y coord, a new y, and the ss name.      
 ;   Returns an old umbrella.                                              
 ; 
 (DEFUN VMOV (pa gnupt ss / dist angg)
  (setq jumps 50)
  (setq dist (/ (- pa gnupt) jumps))
  (repeat jumps
          (command ".move" ss "" "0,0" (list 0 dist))))
 ; Ŀ
 ;   Vmov end.                                                             
 ; 

 ; Ŀ
 ;   VVB - vertically respace a column of text.                            
 ;   Takes two arguments - an ss and a centre point y coordinate.          
 ;   Returns nothing.                                                      
 ; 
 (DEFUN VVB (ss yins incr / txa enn nna ya txb yb txh yy nn yins)
  (while (setq txa (ssname ss 0))             ; first entity name
         (setq enn 1)                         ; entity to test - initialize
         (setq nna (entget txa))              ; the whole thing
         (setq ya (cdr (assoc 10 nna)))       ; Y insertion
 ; Ŀ
 ;   Find the highest entity.                                              
 ; 
         (while (setq txb (ssname ss enn))                 ; next entity
                (setq yb (cdr (assoc 10 (entget txb))))    ; Y insertion
                (if (> (cadr yb) (cadr ya))                ; if txb highest
                    (progn
                         (setq txa txb)                    ; next becomes txa
                         (setq nna (entget txa))           ; get whole thing
                         (setq ya (cdr (assoc 10 nna)))))  ; and Y insertion
                (setq enn (1+ enn)))                       ; next entity
 ; Ŀ
 ;   And move it.                                                          
 ; 
         (if (or (= (cdr (assoc 72 nna)) 2)
                 (= (cdr (assoc 72 nna)) 4)
                 (= (cdr (assoc 72 nna)) 1))
             (progn
                   (if (= (cdr (assoc 72 nna)) 4)
                       (progn
                             (setq txh (cdr (assoc 40 (entget (ssname ss 0)))))
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) (+ (/ txh 2) yins)))
                             (command "move" txa "" yy nn))
                       (progn
                             (setq yy (cdr (assoc 11 nna)))
                             (setq nn (list (car yy) yins))
                             (command "move" txa "" yy nn))))
             (progn
                   (setq yy (cdr (assoc 10 nna)))
                   (setq nn (list (car yy) yins))
                   (command "move" txa "" yy nn)))
 ; Ŀ
 ;   Increment insertion point, remove entity from ss, loop.               
 ; 
         (setq yins (- yins incr))
         (ssdel txa ss))
 (princ))
 ; Ŀ
 ;   VVB end.                                                              
 ; 

 ; Ŀ
 ;   Tear.                                                                 
 ; 
 (DEFUN C:TEAR (/ ss scal ssav osmo cc rr xa ya cenu incr intime ptlist mtime
                                                    ptlst2 ul lr dista curcen)
  (setvar "cmdecho" 0)
  (st1)
  (command "undo" "be")
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq scal (misps))
      (setq scal (getvar "dimscale")))
 ; Ŀ
 ;   Get an ss of text and/or attdefs.                                     
 ; 
  (prompt "Pick text/attdefs to right justify: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "attdef")
                        (-4 . "or>"))))
      (progn
           (setq ssav (ssget "p"))
 ; Ŀ
 ;   Find the desired vertical and horizontal centre point coordinates.    
 ;   (This routine doesn't use the X centrepoint.)                         
 ; 
           (setq osmo (getvar "osmode"))
           (setvar "osmode" 32)
           (setq cc (getpoint "First corner: "))
           (setq rr (getpoint cc "\nOpposite corner or <Return>:"))
           (setvar "osmode" osmo)
           (if rr 
               (progn
                    (setq xa (/ (+ (car cc) (car rr)) 2))
                    (setq ya (/ (+ (cadr cc) (cadr rr)) 2)))
               (progn
                    (setq xa (car cc))
                    (setq ya (cadr cc))))
 ; Ŀ
 ;   Line spacing.                                                         
 ; 
           (setq incr (* 1.65 (cdr (assoc 40 (entget (ssname ss 0))))))
;           (setq incrp (getdist (list xa ya)
;                          (strcat "\nLine spacing <" (rtos incr 2 2) ">:")))
;           (if incrp (setq incr incrp))
 ; Ŀ
 ;   Save the data input time, restart the timer.                          
 ; 
           (setq intime (ct1))
           (st1)
 ; Ŀ
 ;   Outline the text, save the corner points.                             
 ; 
           (setq ptlist (grout ss nil (* scal 0.5)))
 ; Ŀ
 ;   Find the right point: 2 x dimscale from the rightmost corner.         
 ; 
           (if rr
              (progn
                   (setq lpa1 (car rr))
                   (setq lpa2 (car cc))
                   (setq ritpt (max lpa1 lpa2)))
              (setq ritpt (car cc)))
           (setq ritpt (- ritpt (* scal 2)))
 ; Ŀ
 ;   Left rejustify the ss.                                                
 ; 
           (vbrxa ss ritpt)
 ; Ŀ
 ;   And vertically respace it.                                            
 ; 
           (vvb ss (caddr (assoc 10 (entget (ssname ss 0)))) incr)
 ; Ŀ
 ;   Get the new corner points, don't outline the text.                    
 ; 
           (setq ptlst2 (grout ssav nil (* scal 0.5)))
 ; Ŀ
 ;   Get the text ss vertical midpoint.                                    
 ; 
           (setq ul (cadar ptlst2))
           (setq ll (cadr (nth 3 ptlst2)))
           (setq vmid (/ (+ ul ll) 2))
 ; Ŀ
 ;   Move the new ss centre point to the box centre.                       
 ; 
           (vmov ya vmid ssav)))
 ; Ŀ
 ;   Calculate elapsed time, print the value.                              
 ; 
  (command "undo" "end")
  (setq mtime (ct1))
  (write-line (strcat "\nOperator time: " intime " seconds, Program time: "
                      mtime " seconds."))
 (princ))